﻿import viz
import vizcam

viz.go()

ground = viz.add("piazza.osgb")

viz.MainView.collision( viz.ON )
viz.mouse.setOverride(viz.ON)
viz.MainView.stepsize(10) 
viz.MainView.gravity(3)

button = viz.addButton()
button.setPosition(0.5,0.5)

def onUpdate(e):
	cammovespeed =2
	camturnspeed =20
	if viz.key.isDown("w") == 1:
		viz.MainView.move([0,0,cammovespeed*viz.elapsed()],viz.BODY_ORI)
	if viz.key.isDown("s") == 1:
		viz.MainView.move([0,0,-cammovespeed*viz.elapsed()],viz.BODY_ORI)
	if viz.key.isDown("q") == 1:
		viz.MainView.move([-cammovespeed*viz.elapsed(),0,0],viz.BODY_ORI)
	if viz.key.isDown("e") == 1:
		viz.MainView.move([cammovespeed*viz.elapsed(),0,0],viz.BODY_ORI)
	if viz.key.isDown("d"):
		viz.MainView.setEuler([camturnspeed*viz.elapsed(),0,0],viz.BODY_ORI,viz.REL_PARENT)
	if viz.key.isDown("a"):
		viz.MainView.setEuler([-camturnspeed*viz.elapsed(),0,0],viz.BODY_ORI,viz.REL_PARENT)

def onButton(obj, state):
	if obj == button:
		
		viz.MainView.collision( viz.OFF )
		viz.mouse.setOverride(viz.OFF)
		viz.MainView.stepsize(0) 
		viz.MainView.gravity(0)
		vizcam.PivotNavigate()


viz.callback(viz.BUTTON_EVENT,onButton)
viz.callback(viz.UPDATE_EVENT,onUpdate,priority=100)